<?php
include("templates/headers/inc.php");

// If we have a session, redirect !
if($_SESSION && isset($_SESSION["USER_ID"])) {
	header("Location: home.php");
	exit;
}

// Include the JS file
$js_files = array();

// Get website config
$site_config = $dbh->prepare("SELECT * FROM config WHERE config_name IN ('website_name','website_tagline')");
$site_config->execute();

$config_array = array();

while($config = $site_config->fetch(PDO::FETCH_ASSOC)) {
	$config_array[$config["config_name"]] = $config["config_value"];
}

$website_name = $config_array["website_name"];
$website_tagline = $config_array["website_tagline"];

// Initialize FB SDK
$fb = new \Facebook\Facebook([
	'app_id' => FB_APP_ID,
	'app_secret' => FB_APP_SECRET,
	'default_graph_version' => 'v2.3'
]);	

$helper = $fb->getRedirectLoginHelper();

// Get FB Login URL
$permissions = ['email']; // Optional permissions
$loginUrl = $helper->getLoginUrl(URL . "/fb-login.php", $permissions);

$email = "";
$username = "";
$error = "";

// Manage Post
if($_POST) {
	
	if(isset($_POST["username"]) && isset($_POST["email"]) && isset($_POST["password"]) && isset($_POST["repassword"])) {
	
		$username = $_POST["username"];
		$email = $_POST["email"];
		$password = $_POST["password"];
		$repassword = $_POST["repassword"];
		
		if(strlen($username) < 2) {
			
			$error = "Your firstname must be at least 2 characters long.";
			
		} else if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
			
			$error = "You need to specify a valid email address.";
			
		} else if(strlen($password) < 4) {
			
			$error = "You need to specify a password with at last 4 characters.";
			
		} else if($password != $repassword) {
			
			$error = "Your password and confirmation password are different.";
			
		} else {
			
			
			$check_email_sql = $dbh->prepare("SELECT id FROM user WHERE email = :email");
			$check_email_sql->bindParam(":email", $email);
			$check_email_sql->execute();
			
			if($check_email_sql->rowCount() > 0) {
			
				$error = "This email is already taken. Please choose another one.";
				
			} else {
				
				// Count total users in the DB
				$user_total_sql = $dbh->prepare("SELECT id FROM user");
				$user_total_sql->execute();
				$total_users = $user_total_sql->rowCount();
				
				if($total_users == 0) {
					$rank = 1;
				} else {
					$rank = 0;
				}
				
				$password = sha1($password);
				
				// We can create the user
				$stmt = $dbh->prepare("INSERT INTO 
									   user 
									   SET 
									   fb_id = '',
									   fullname = :username,
									   password = :password,
									   email = :email,
									   profile_picture = '',
									   created_at = NOW(),
									   rank = :rank,
									   nb_quiz_created = 0,
									   origin = '',
									   status = 1");
									
				$stmt->bindParam(':username', $username);
				$stmt->bindParam(':password', $password);
				$stmt->bindParam(':email', $email);
				$stmt->bindParam(':rank', $rank);
				$stmt->execute();
				
				$user_id = $dbh->lastInsertId();
				
				
				// Open session
				$_SESSION["USER_ID"] = $user_id;
				$_SESSION["EMAIL"] = $email;
				$_SESSION["FULL_NAME"] = $username;
				$_SESSION["PROFILE_PICTURE"] = '';
				$_SESSION["RANK"] = $rank;
				
				if($_COOKIE && isset($_COOKIE["redirect_quiz_id"])) {
		
					$quiz_id = $_COOKIE["redirect_quiz_id"];
					
					// Delete the cookie...
					unset($_COOKIE['redirect_quiz_id']);
					setcookie('redirect_quiz_id', null, -1, '/');
					
					$stmt = $dbh->prepare("	UPDATE user
											SET 
											origin = 'quiz'
											WHERE id = :user_id
											");
										
					$stmt->bindParam(':user_id', $user_id);
					$stmt->execute();
					
					// Redirect..
					header("Location: " . URL . "/quiz.php?id=" . $quiz_id);
					
				} else {
					
					$stmt = $dbh->prepare("	UPDATE user
											SET 
											origin = 'home'
											WHERE id = :user_id
											");
										
					$stmt->bindParam(':user_id', $user_id);
					$stmt->execute();
				
					// Redirects
					header("Location: create-quiz.php?action=register");
			
				
				}
			
			}
			
		}
	
	}
	
}

// -- Include the header template
include("templates/headers/unlogged_header.php");
?>

<div class="row">
	
	<div class="login-block col-md-6 offset-md-3">
		<h3>Sign Up</h3>
		<small>Create an account for free</small>
        <div class="row row_sign_up">
															
			<div class="col-md-8 offset-md-2 d-flex align-items-center">
				<form class="user user_sign_up" action="" method="POST">
					<?php
					if($error != "") {
					?>
					<div class="alert alert-danger alert-center">
						
						<?php echo $error; ?>
						
					</div>
					<?php
					}	
					?>											
				    <div class="form-group row">
				        <div class="col-md-6">
				            <input type="text" class="form-control form-control-user" placeholder="Enter Firstname" name="username" value="<?php echo $username; ?>">
				        </div>
				        <div class="col-md-6">
				            <input type="text" class="form-control form-control-user" placeholder="Enter Email" name="email" value="<?php echo $email; ?>">
				        </div>
				    </div>
				    <div class="form-group row">
				        <div class="col-md-6">										            
					        <input type="password" class="form-control form-control-user" placeholder="Enter Password" name="password">

				        </div>
				        <div class="col-md-6">										            
					        <input type="password" class="form-control form-control-user" placeholder="Re-Enter Password" name="repassword">
				        </div>
			    	</div>
				    <button type="submit" class="btn btn-primary btn-user btn-block">
				    CREATE ACCOUNT
				    </button>
				    <div class="no_account_sign_up">
				    	Already have an account? <a href="index.php">Sign In</a>
				    </div>
				</form>
			</div>
			
		</div>
		
	</div>
	
</div>

<?php
// -- Include the footer template
include("templates/footers/global_footer.php");	
?>